function [residual, g1, g2, g3] = World_Economy_Cartel_dAC_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations.
%                                          Dynare may prepend or append auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%   g3        [M_.endo_nbr by (M_.endo_nbr)^3] double   Third derivatives matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 70, 1);

%
% Model equations
%

T18 = exp(y(19))-params(9)*exp(y(18))^(1+params(8))/(1+params(8));
T21 = T18^(-params(14));
T33 = params(21)^(-1);
T50 = exp(y(1))*y(35)+T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(46)*(-(exp(y(1))*exp(y(22))));
T66 = params(12)^(1-params(4));
T85 = params(13)^(1-params(4));
T121 = exp(y(1))*exp(y(4))-exp(y(4))*params(6)*exp(y(31)-y(24))^(params(5)-1);
T176 = exp(y(6))*y(48)+params(21)*y(39)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))+params(21)*y(48)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))))+params(21)*y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
T199 = exp(y(7))*y(47)+params(21)*y(39)*exp(y(7))*params(6)*exp(y(11)*params(5))+params(21)*y(47)*(-(exp(y(7))*(1-exp(y(11)))))+params(21)*y(51)*(-(exp(y(11))*exp(y(7))));
T243 = params(21)*y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(21)*y(39)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))+params(21)*y(48)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
T249 = params(21)^2;
T273 = (-(exp(y(22))*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*exp(y(11)*params(5)))));
T274 = y(43)*T273;
T327 = exp(y(16))^(1/params(2));
T329 = (-1)/params(2);
T331 = exp(y(15))*getPowerDeriv(exp(y(15)),T329,1);
T337 = (params(2)-1)/params(2);
T339 = exp(y(15))*getPowerDeriv(exp(y(15)),T337,1);
T349 = exp(y(17))^params(3);
T351 = exp(y(18))^(1-params(3));
T352 = T349*T351;
T353 = T352^T337;
T357 = (1-params(11))*exp(T337*y(23))*T353+params(11)*exp(y(15))^T337;
T359 = getPowerDeriv(T357,params(2)/(params(2)-1),1);
T372 = exp(y(17))^(params(3)-1);
T373 = T352^T329;
T377 = exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),1);
T386 = exp(y(18))^(-params(3));
T395 = exp(y(15))^T329;
T411 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3),1);
T413 = getPowerDeriv(T352,T337,1);
T415 = (1-params(11))*exp(T337*y(23))*T351*T411*T413;
T420 = T327*exp(T337*y(23))*(1-params(11))*(1-params(3));
T423 = getPowerDeriv(T352,T329,1);
T424 = T351*T411*T423;
T427 = T411*T373*T420+T349*T420*T424;
T433 = T327*exp(T337*y(23))*(1-params(11))*params(3);
T438 = exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,1);
T442 = (-(T351*(T372*T424*T433+T373*T433*T438)));
T468 = exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),1);
T471 = (-(params(9)*T468/(1+params(8))));
T472 = getPowerDeriv(T18,(-params(14)),1);
T473 = T471*T472;
T486 = (-(exp(T337*y(23))*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
T490 = exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),1);
T505 = exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),1);
T511 = (1-params(11))*exp(T337*y(23))*T413*T349*T490;
T559 = params(9)^((-1)/params(8));
T564 = exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),1);
T575 = exp(y(22))*params(6)*params(5)*exp(y(11)*(params(5)-1))-exp(y(22))*(exp(y(1))-y(13));
T590 = (-(exp(y(22))*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)))));
T599 = T33*y(46)*T575+exp(y(22))*y(42)+T33*y(41)*(-(exp(y(22))*(1+exp(y(20))-params(10))))+T33*y(43)*T590+T33*y(44)*(-(y(14)*exp(y(22))*(1-params(7))));
T626 = T353*(1-params(11))*T337*exp(T337*y(23));
T643 = getPowerDeriv(exp(y(31)-y(24)),params(5)-1,1);
T665 = y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+y(39)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
residual(1) = T21*exp(y(1))*exp(y(4))+(-y(57))+T50+y(57)*params(21);
residual(2) = T21*(-exp(y(2)))+(-y(59))+y(50)*(-(T66*params(4)*exp(y(2)*params(4))))+exp(y(2))*y(39)+params(21)*y(59);
residual(3) = (-y(58))+y(49)*(-(T85*params(4)*exp(params(4)*y(3))))+y(45)*y(14)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1))+y(39)*exp(y(3))+params(21)*y(58);
residual(4) = T21*T121+(-y(61))+y(53)*(-exp(y(4)))+exp(y(4))*y(52)+params(21)*y(61);
residual(5) = (-y(60))+y(53)*(-exp(y(5)))+exp(y(5))*y(51)+params(21)*y(60);
residual(6) = T176;
residual(7) = T199;
residual(8) = y(50)*exp(y(8))+y(48)*(-(exp(y(8))*params(7)))+params(21)*y(50)*(-(exp(y(8))*(1-params(7))));
residual(9) = y(49)*exp(y(9))+y(47)*(-(params(7)*exp(y(9))))+params(21)*y(49)*(-((1-params(7))*exp(y(9))));
residual(10) = params(21)*(-y(64))+T243+params(21)*y(56)*(-exp(y(10)))+y(64)*T249;
residual(11) = params(21)*(-y(63))+params(21)*y(51)*(-(exp(y(11))*exp(y(7))))+y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T274+params(21)*y(39)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(21)*y(47)*(-(exp(y(7))*(-exp(y(11)))))+T249*y(63);
residual(12) = exp(y(12))*y(38);
residual(13) = y(44)*(-params(7))+y(43)+T33*y(43)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(46);
residual(14) = y(45)*T85*params(4)*exp(y(3)*(params(4)-1))+y(44)+T33*y(44)*(-(exp(y(22))*(1-params(7))));
residual(15) = y(53)*exp(y(15))+y(35)*(-(params(11)*T327*T331))+y(34)*(-(params(11)*T339*T359));
residual(16) = (-y(62))+y(39)*(-exp(y(16)))+y(37)*(-(T351*T372*T373*exp(T337*y(23))*(1-params(11))*params(3)*T377))+y(36)*(-(T386*T349*T373*T377*exp(T337*y(23))*(1-params(11))*(1-params(3))))+y(35)*(-(T395*params(11)*T377))+exp(y(16))*y(34)+params(21)*y(62);
residual(17) = y(39)*exp(y(17))+params(21)*y(34)*(-(T359*T415))+params(21)*y(36)*(-(T386*T427))+params(21)*y(37)*T442+params(21)*y(38)*(-(exp(y(18)*(1-params(3)))*exp(T337*y(23))*params(3)*exp(y(17)*params(3))))+params(21)*y(39)*(-(exp(y(17))*(1-params(10))));
residual(18) = (T121-exp(y(2)))*T473+y(42)*(-(T473*params(1)/T21))+exp(y(18))*y(40)+y(38)*T486+y(37)*(-(T372*T373*T433*T490+T351*T372*T433*T423*T349*T490))+y(36)*(-(T386*T349*T420*T423*T349*T490+T349*T373*T420*T505))+y(34)*(-(T359*T511))+params(21)*y(42)*(-((-(T473*T21*params(1)))/(T21*T21)));
residual(19) = (T121-exp(y(2)))*exp(y(19))*T472+y(42)*(-(params(1)*exp(y(19))*T472/T21))+exp(y(19))*y(39)+params(21)*y(42)*(-((-(T21*params(1)*exp(y(19))*T472))/(T21*T21)));
residual(20) = y(37)*exp(y(20))+T33*y(41)*(-(exp(y(22))*exp(y(20))));
residual(21) = y(40)*(-(T559*T564))+y(36)*exp(y(21));
residual(22) = T599;
residual(23) = y(55)+params(21)*y(55)*(-params(15))+y(38)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T337*exp(T337*y(23))))+y(37)*(-(T351*T372*T373*T327*(1-params(11))*params(3)*T337*exp(T337*y(23))))+y(36)*(-(T386*T349*T373*T327*(1-params(11))*(1-params(3))*T337*exp(T337*y(23))))+y(34)*(-(T359*T626))+T249*y(55)*(-params(16));
residual(24) = T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T643))+y(64)+params(21)*(-y(64))+y(54)+T665;
residual(25) = y(57);
residual(26) = y(58);
residual(27) = y(59);
residual(28) = y(60);
residual(29) = y(61);
residual(30) = y(62);
residual(31) = T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T643))+y(56)*exp(y(31));
residual(32) = y(63);
residual(33) = y(64);
residual(34) = exp(y(16))-T357^(params(2)/(params(2)-1));
residual(35) = exp(y(1))-params(11)*T327*T395;
residual(36) = exp(y(21))-T386*T349*T373*T420;
residual(37) = exp(y(20))-T351*T372*T373*T433;
residual(38) = exp(y(12))-exp(y(18)*(1-params(3)))*exp(T337*y(23))*exp(y(17)*params(3));
residual(39) = exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))+exp(y(7))*params(6)*exp(y(11)*params(5))+exp(y(2))+exp(y(3))+exp(y(19))+exp(y(17))-(exp(y(16))+exp(y(17))*(1-params(10)));
residual(40) = exp(y(18))-T559*exp(y(21))^(1/params(8));
residual(41) = 1-exp(y(22))*(1+exp(y(20))-params(10));
residual(42) = exp(y(22))-T21*params(1)/T21;
residual(43) = y(13)-exp(y(22))*(exp(y(1))*exp(y(11))+(1-exp(y(11)))*y(13)-params(6)*exp(y(11)*params(5)));
residual(44) = y(14)-(y(14)*exp(y(22))*(1-params(7))+params(7)*y(13));
residual(45) = y(14)*T85*params(4)*exp(y(3)*(params(4)-1))-1;
residual(46) = T575;
residual(47) = exp(y(7))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(9)));
residual(48) = exp(y(6))-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))+exp(y(8))*params(7));
residual(49) = exp(y(9))-((1-params(7))*exp(y(9))+T85*exp(params(4)*y(3)));
residual(50) = exp(y(8))-(exp(y(8))*(1-params(7))+T66*exp(y(2)*params(4)));
residual(51) = exp(y(5))-exp(y(11))*exp(y(7));
residual(52) = exp(y(4))-exp(y(6))*exp((-y(24)))*exp(y(10));
residual(53) = exp(y(15))-(exp(y(4))+exp(y(5)));
residual(54) = y(24)-x(1);
residual(55) = y(23)-(x(2)+y(23)*params(15)+y(23)*params(16));
residual(56) = exp(y(31))-exp(y(10));
residual(57) = y(25);
residual(58) = y(26);
residual(59) = y(27);
residual(60) = y(28);
residual(61) = y(29);
residual(62) = y(30);
residual(63) = y(32);
residual(64) = y(33);
lhs =y(65);
rhs =y(64);
residual(65)= lhs-rhs;
lhs =y(66);
rhs =y(63);
residual(66)= lhs-rhs;
lhs =y(67);
rhs =y(55);
residual(67)= lhs-rhs;
lhs =y(68);
rhs =y(23);
residual(68)= lhs-rhs;
lhs =y(69);
rhs =y(11);
residual(69)= lhs-rhs;
lhs =y(70);
rhs =y(10);
residual(70)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(70, 70);

  %
  % Jacobian matrix
  %

T869 = params(21)*y(51)*(-(exp(y(11))*exp(y(7))))+params(21)*y(39)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5))+params(21)*y(47)*(-(exp(y(7))*(-exp(y(11)))));
T927 = getPowerDeriv(T357,params(2)/(params(2)-1),2);
T952 = T377+exp(y(16))*exp(y(16))*getPowerDeriv(exp(y(16)),1/params(2),2);
T979 = y(36)*(-(T386*(T373*T377*exp(T337*y(23))*(1-params(11))*(1-params(3))*T411+T349*T377*exp(T337*y(23))*(1-params(11))*(1-params(3))*T424)));
T987 = y(37)*(-(T351*(T372*exp(T337*y(23))*(1-params(11))*params(3)*T377*T424+T373*exp(T337*y(23))*(1-params(11))*params(3)*T377*T438)));
T1004 = y(37)*(-(T372*T373*exp(T337*y(23))*(1-params(11))*params(3)*T377*T490+T351*T372*exp(T337*y(23))*(1-params(11))*params(3)*T377*T423*T349*T490))+y(36)*(-(T386*T349*T377*exp(T337*y(23))*(1-params(11))*(1-params(3))*T423*T349*T490+T349*T373*T377*exp(T337*y(23))*(1-params(11))*(1-params(3))*T505));
T1017 = y(37)*(-(T351*T372*T373*T377*(1-params(11))*params(3)*T337*exp(T337*y(23))))+y(36)*(-(T386*T349*T373*T377*(1-params(11))*(1-params(3))*T337*exp(T337*y(23))));
T1026 = T411+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3),2);
T1028 = getPowerDeriv(T352,T337,2);
T1043 = getPowerDeriv(T352,T329,2);
T1047 = T423*T351*T1026+T351*T411*T351*T411*T1043;
T1129 = y(37)*(-(T351*(T438*T373*T327*(1-params(11))*params(3)*T337*exp(T337*y(23))+T372*T424*T327*(1-params(11))*params(3)*T337*exp(T337*y(23)))));
T1136 = y(36)*(-(T386*(T411*T373*T327*(1-params(11))*(1-params(3))*T337*exp(T337*y(23))+T349*T424*T327*(1-params(11))*(1-params(3))*T337*exp(T337*y(23)))));
T1191 = getPowerDeriv(T18,(-params(14)),2);
T1195 = T472*(-(params(9)*(T468+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1+params(8),2))/(1+params(8))))+T471*T471*T1191;
T1211 = T490+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),1-params(3),2);
T1300 = y(37)*(-(T490*T372*T373*T327*(1-params(11))*params(3)*T337*exp(T337*y(23))+T351*T372*T423*T349*T490*T327*(1-params(11))*params(3)*T337*exp(T337*y(23))));
T1307 = y(36)*(-(T505*T349*T373*T327*(1-params(11))*(1-params(3))*T337*exp(T337*y(23))+T386*T349*T423*T349*T490*T327*(1-params(11))*(1-params(3))*T337*exp(T337*y(23))));
T1449 = getPowerDeriv(exp(y(31)-y(24)),params(5)-1,2);
  g1(1,1)=T21*exp(y(1))*exp(y(4))+T50;
  g1(1,4)=T21*exp(y(1))*exp(y(4));
  g1(1,11)=T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(1,18)=exp(y(1))*exp(y(4))*T473;
  g1(1,19)=exp(y(1))*exp(y(4))*exp(y(19))*T472;
  g1(1,22)=T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(46)*(-(exp(y(1))*exp(y(22))));
  g1(1,35)=exp(y(1));
  g1(1,43)=T33*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(1,46)=T33*(-(exp(y(1))*exp(y(22))));
  g1(1,57)=(-1)+params(21);
  g1(2,2)=T21*(-exp(y(2)))+exp(y(2))*y(39)+y(50)*(-(T66*params(4)*params(4)*exp(y(2)*params(4))));
  g1(2,18)=(-exp(y(2)))*T473;
  g1(2,19)=(-exp(y(2)))*exp(y(19))*T472;
  g1(2,39)=exp(y(2));
  g1(2,50)=(-(T66*params(4)*exp(y(2)*params(4))));
  g1(2,59)=(-1)+params(21);
  g1(3,3)=y(49)*(-(T85*params(4)*params(4)*exp(params(4)*y(3))))+y(39)*exp(y(3))+y(45)*y(14)*T85*params(4)*(params(4)-1)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,14)=y(45)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,39)=exp(y(3));
  g1(3,45)=y(14)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(3,49)=(-(T85*params(4)*exp(params(4)*y(3))));
  g1(3,58)=(-1)+params(21);
  g1(4,1)=T21*exp(y(1))*exp(y(4));
  g1(4,4)=T21*T121+y(53)*(-exp(y(4)))+exp(y(4))*y(52);
  g1(4,18)=T121*T473;
  g1(4,19)=T121*exp(y(19))*T472;
  g1(4,24)=T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T643));
  g1(4,31)=T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T643));
  g1(4,52)=exp(y(4));
  g1(4,53)=(-exp(y(4)));
  g1(4,61)=(-1)+params(21);
  g1(5,5)=y(53)*(-exp(y(5)))+exp(y(5))*y(51);
  g1(5,51)=exp(y(5));
  g1(5,53)=(-exp(y(5)));
  g1(5,60)=(-1)+params(21);
  g1(6,6)=T176;
  g1(6,10)=T243;
  g1(6,24)=params(21)*y(39)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5))+params(21)*y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(21)*y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(6,39)=params(21)*exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)));
  g1(6,48)=exp(y(6))+params(21)*(-(exp(y(6))*(1-exp((-y(24)))*exp(y(10)))));
  g1(6,52)=params(21)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(7,7)=T199;
  g1(7,11)=T869;
  g1(7,39)=params(21)*exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(7,47)=exp(y(7))+params(21)*(-(exp(y(7))*(1-exp(y(11)))));
  g1(7,51)=params(21)*(-(exp(y(11))*exp(y(7))));
  g1(8,8)=y(50)*exp(y(8))+y(48)*(-(exp(y(8))*params(7)))+params(21)*y(50)*(-(exp(y(8))*(1-params(7))));
  g1(8,48)=(-(exp(y(8))*params(7)));
  g1(8,50)=exp(y(8))+params(21)*(-(exp(y(8))*(1-params(7))));
  g1(9,9)=y(49)*exp(y(9))+y(47)*(-(params(7)*exp(y(9))))+params(21)*y(49)*(-((1-params(7))*exp(y(9))));
  g1(9,47)=(-(params(7)*exp(y(9))));
  g1(9,49)=exp(y(9))+params(21)*(-((1-params(7))*exp(y(9))));
  g1(10,6)=T243;
  g1(10,10)=params(21)*y(56)*(-exp(y(10)))+params(21)*y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+params(21)*y(48)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+params(21)*y(39)*exp(y(6))*params(6)*params(5)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(10,24)=params(21)*y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+params(21)*y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+params(21)*y(39)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(10,39)=params(21)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(10,48)=params(21)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(10,52)=params(21)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(10,56)=params(21)*(-exp(y(10)));
  g1(10,64)=T249+(-params(21));
  g1(11,1)=y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(11,7)=T869;
  g1(11,11)=params(21)*y(51)*(-(exp(y(11))*exp(y(7))))+params(21)*y(47)*(-(exp(y(7))*(-exp(y(11)))))+y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(11)*(params(5)-1))+y(43)*(-(exp(y(22))*(exp(y(1))*exp(y(11))+y(13)*(-exp(y(11)))-params(6)*params(5)*params(5)*exp(y(11)*params(5)))))+params(21)*y(39)*exp(y(7))*params(6)*params(5)*params(5)*exp(y(11)*params(5));
  g1(11,13)=y(43)*(-(exp(y(22))*(-exp(y(11)))));
  g1(11,22)=y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T274;
  g1(11,39)=params(21)*exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(11,43)=T273;
  g1(11,46)=exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(11,47)=params(21)*(-(exp(y(7))*(-exp(y(11)))));
  g1(11,51)=params(21)*(-(exp(y(11))*exp(y(7))));
  g1(11,63)=T249+(-params(21));
  g1(12,12)=exp(y(12))*y(38);
  g1(12,38)=exp(y(12));
  g1(13,11)=T33*y(43)*(-(exp(y(22))*(-exp(y(11)))));
  g1(13,22)=T33*y(43)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(46);
  g1(13,43)=1+T33*(-(exp(y(22))*(1-exp(y(11)))));
  g1(13,44)=(-params(7));
  g1(13,46)=T33*exp(y(22));
  g1(14,3)=y(45)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(14,22)=T33*y(44)*(-(exp(y(22))*(1-params(7))));
  g1(14,44)=1+T33*(-(exp(y(22))*(1-params(7))));
  g1(14,45)=T85*params(4)*exp(y(3)*(params(4)-1));
  g1(15,15)=y(53)*exp(y(15))+y(35)*(-(params(11)*T327*(T331+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T329,2))))+y(34)*(-(T359*params(11)*(T339+exp(y(15))*exp(y(15))*getPowerDeriv(exp(y(15)),T337,2))+params(11)*T339*params(11)*T339*T927));
  g1(15,16)=y(35)*(-(T331*params(11)*T377));
  g1(15,17)=y(34)*(-(params(11)*T339*T415*T927));
  g1(15,18)=y(34)*(-(params(11)*T339*T511*T927));
  g1(15,23)=y(34)*(-(params(11)*T339*T626*T927));
  g1(15,34)=(-(params(11)*T339*T359));
  g1(15,35)=(-(params(11)*T327*T331));
  g1(15,53)=exp(y(15));
  g1(16,15)=y(35)*(-(T331*params(11)*T377));
  g1(16,16)=y(39)*(-exp(y(16)))+y(37)*(-(T351*T372*T373*exp(T337*y(23))*(1-params(11))*params(3)*T952))+y(36)*(-(T386*T349*T373*exp(T337*y(23))*(1-params(11))*(1-params(3))*T952))+exp(y(16))*y(34)+y(35)*(-(T395*params(11)*T952));
  g1(16,17)=T979+T987;
  g1(16,18)=T1004;
  g1(16,23)=T1017;
  g1(16,34)=exp(y(16));
  g1(16,35)=(-(T395*params(11)*T377));
  g1(16,36)=(-(T386*T349*T373*T377*exp(T337*y(23))*(1-params(11))*(1-params(3))));
  g1(16,37)=(-(T351*T372*T373*exp(T337*y(23))*(1-params(11))*params(3)*T377));
  g1(16,39)=(-exp(y(16)));
  g1(16,62)=(-1)+params(21);
  g1(17,15)=params(21)*y(34)*(-(T415*params(11)*T339*T927));
  g1(17,16)=params(21)*T979+params(21)*T987;
  g1(17,17)=y(39)*exp(y(17))+params(21)*y(39)*(-(exp(y(17))*(1-params(10))))+params(21)*y(34)*(-(T415*T415*T927+T359*(1-params(11))*exp(T337*y(23))*(T413*T351*T1026+T351*T411*T351*T411*T1028)))+params(21)*y(36)*(-(T386*(T373*T420*T1026+T411*T420*T424+T411*T420*T424+T349*T420*T1047)))+params(21)*y(37)*(-(T351*(T424*T433*T438+T372*T433*T1047+T424*T433*T438+T373*T433*(T438+exp(y(17))*exp(y(17))*getPowerDeriv(exp(y(17)),params(3)-1,2)))))+params(21)*y(38)*(-(exp(y(18)*(1-params(3)))*exp(T337*y(23))*params(3)*params(3)*exp(y(17)*params(3))));
  g1(17,18)=params(21)*y(34)*(-(T415*T511*T927+T359*(1-params(11))*exp(T337*y(23))*(T413*T411*T490+T351*T411*T349*T490*T1028)))+params(21)*y(36)*(-(T427*T505+T386*(T411*T420*T423*T349*T490+T349*T420*(T423*T411*T490+T351*T411*T349*T490*T1043))))+params(21)*y(37)*(-((T372*T424*T433+T373*T433*T438)*T490+T351*(T438*T433*T423*T349*T490+T372*T433*(T423*T411*T490+T351*T411*T349*T490*T1043))))+params(21)*y(38)*(-(exp(T337*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))));
  g1(17,23)=params(21)*y(34)*(-(T359*T351*T411*T413*(1-params(11))*T337*exp(T337*y(23))+T415*T626*T927))+params(21)*T1136+params(21)*T1129+params(21)*y(38)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T337*exp(T337*y(23))));
  g1(17,34)=params(21)*(-(T359*T415));
  g1(17,36)=params(21)*(-(T386*T427));
  g1(17,37)=params(21)*T442;
  g1(17,38)=params(21)*(-(exp(y(18)*(1-params(3)))*exp(T337*y(23))*params(3)*exp(y(17)*params(3))));
  g1(17,39)=exp(y(17))+params(21)*(-(exp(y(17))*(1-params(10))));
  g1(18,1)=exp(y(1))*exp(y(4))*T473;
  g1(18,2)=(-exp(y(2)))*T473;
  g1(18,4)=T121*T473;
  g1(18,15)=y(34)*(-(T511*params(11)*T339*T927));
  g1(18,16)=T1004;
  g1(18,17)=y(38)*(-(exp(T337*y(23))*params(3)*exp(y(17)*params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(37)*(-((T372*T424*T433+T373*T433*T438)*T490+T351*(T438*T433*T423*T349*T490+T372*T433*(T349*T490*T351*T411*T1043+T423*T411*T490))))+y(36)*(-(T386*(T411*T420*T423*T349*T490+T349*T420*(T349*T490*T351*T411*T1043+T423*T411*T490))+T427*T505))+y(34)*(-(T511*T415*T927+T359*(1-params(11))*exp(T337*y(23))*(T349*T490*T351*T411*T1028+T413*T411*T490)));
  g1(18,18)=(T121-exp(y(2)))*T1195+y(42)*(-((T21*params(1)*T1195-T473*T473*params(1))/(T21*T21)))+exp(y(18))*y(40)+y(38)*(-(exp(T337*y(23))*exp(y(17)*params(3))*(1-params(3))*(1-params(3))*exp(y(18)*(1-params(3)))))+y(37)*(-(T490*T372*T433*T423*T349*T490+T372*T373*T433*T1211+T490*T372*T433*T423*T349*T490+T351*T372*T433*(T349*T490*T349*T490*T1043+T423*T349*T1211)))+y(36)*(-(T349*T420*T423*T349*T490*T505+T386*T349*T420*(T349*T490*T349*T490*T1043+T423*T349*T1211)+T349*T420*T423*T349*T490*T505+T349*T373*T420*(T505+exp(y(18))*exp(y(18))*getPowerDeriv(exp(y(18)),(-params(3)),2))))+y(34)*(-(T511*T511*T927+T359*(1-params(11))*exp(T337*y(23))*(T349*T490*T349*T490*T1028+T413*T349*T1211)))+params(21)*y(42)*(-((T21*T21*(-(T473*T473*params(1)+T21*params(1)*T1195))-(-(T473*T21*params(1)))*(T21*T473+T21*T473))/(T21*T21*T21*T21)));
  g1(18,19)=(T121-exp(y(2)))*T471*exp(y(19))*T1191+y(42)*(-((T21*params(1)*T471*exp(y(19))*T1191-T473*params(1)*exp(y(19))*T472)/(T21*T21)))+params(21)*y(42)*(-((T21*T21*(-(T473*params(1)*exp(y(19))*T472+T21*params(1)*T471*exp(y(19))*T1191))-(-(T473*T21*params(1)))*(T21*exp(y(19))*T472+T21*exp(y(19))*T472))/(T21*T21*T21*T21)));
  g1(18,23)=y(38)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T337*exp(T337*y(23))))+T1300+T1307+y(34)*(-(T359*T413*T349*T490*(1-params(11))*T337*exp(T337*y(23))+T511*T626*T927));
  g1(18,24)=T473*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T643));
  g1(18,31)=T473*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T643));
  g1(18,34)=(-(T359*T511));
  g1(18,36)=(-(T386*T349*T420*T423*T349*T490+T349*T373*T420*T505));
  g1(18,37)=(-(T372*T373*T433*T490+T351*T372*T433*T423*T349*T490));
  g1(18,38)=T486;
  g1(18,40)=exp(y(18));
  g1(18,42)=(-(T473*params(1)/T21))+params(21)*(-((-(T473*T21*params(1)))/(T21*T21)));
  g1(19,1)=exp(y(1))*exp(y(4))*exp(y(19))*T472;
  g1(19,2)=(-exp(y(2)))*exp(y(19))*T472;
  g1(19,4)=T121*exp(y(19))*T472;
  g1(19,18)=(T121-exp(y(2)))*exp(y(19))*T471*T1191+y(42)*(-((T21*params(1)*exp(y(19))*T471*T1191-T473*params(1)*exp(y(19))*T472)/(T21*T21)))+params(21)*y(42)*(-((T21*T21*(-(T473*params(1)*exp(y(19))*T472+T21*params(1)*exp(y(19))*T471*T1191))-(-(T21*params(1)*exp(y(19))*T472))*(T21*T473+T21*T473))/(T21*T21*T21*T21)));
  g1(19,19)=(T121-exp(y(2)))*(exp(y(19))*T472+exp(y(19))*exp(y(19))*T1191)+y(42)*(-((T21*params(1)*(exp(y(19))*T472+exp(y(19))*exp(y(19))*T1191)-exp(y(19))*T472*params(1)*exp(y(19))*T472)/(T21*T21)))+exp(y(19))*y(39)+params(21)*y(42)*(-((T21*T21*(-(exp(y(19))*T472*params(1)*exp(y(19))*T472+T21*params(1)*(exp(y(19))*T472+exp(y(19))*exp(y(19))*T1191)))-(-(T21*params(1)*exp(y(19))*T472))*(T21*exp(y(19))*T472+T21*exp(y(19))*T472))/(T21*T21*T21*T21)));
  g1(19,24)=exp(y(19))*T472*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T643));
  g1(19,31)=exp(y(19))*T472*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T643));
  g1(19,39)=exp(y(19));
  g1(19,42)=(-(params(1)*exp(y(19))*T472/T21))+params(21)*(-((-(T21*params(1)*exp(y(19))*T472))/(T21*T21)));
  g1(20,20)=y(37)*exp(y(20))+T33*y(41)*(-(exp(y(22))*exp(y(20))));
  g1(20,22)=T33*y(41)*(-(exp(y(22))*exp(y(20))));
  g1(20,37)=exp(y(20));
  g1(20,41)=T33*(-(exp(y(22))*exp(y(20))));
  g1(21,21)=y(36)*exp(y(21))+y(40)*(-(T559*(T564+exp(y(21))*exp(y(21))*getPowerDeriv(exp(y(21)),1/params(8),2))));
  g1(21,36)=exp(y(21));
  g1(21,40)=(-(T559*T564));
  g1(22,1)=T33*y(43)*(-(exp(y(22))*exp(y(1))*exp(y(11))))+T33*y(46)*(-(exp(y(1))*exp(y(22))));
  g1(22,11)=T33*y(46)*exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1))+T33*T274;
  g1(22,13)=T33*y(43)*(-(exp(y(22))*(1-exp(y(11)))))+T33*exp(y(22))*y(46);
  g1(22,14)=T33*y(44)*(-(exp(y(22))*(1-params(7))));
  g1(22,20)=T33*y(41)*(-(exp(y(22))*exp(y(20))));
  g1(22,22)=T599;
  g1(22,41)=T33*(-(exp(y(22))*(1+exp(y(20))-params(10))));
  g1(22,42)=exp(y(22));
  g1(22,43)=T33*T590;
  g1(22,44)=T33*(-(y(14)*exp(y(22))*(1-params(7))));
  g1(22,46)=T33*T575;
  g1(23,15)=y(34)*(-(T626*params(11)*T339*T927));
  g1(23,16)=T1017;
  g1(23,17)=y(38)*(-(exp(y(18)*(1-params(3)))*params(3)*exp(y(17)*params(3))*T337*exp(T337*y(23))))+T1129+T1136+y(34)*(-(T626*T415*T927+T359*T351*T411*T413*(1-params(11))*T337*exp(T337*y(23))));
  g1(23,18)=y(38)*(-((1-params(3))*exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T337*exp(T337*y(23))))+T1300+T1307+y(34)*(-(T626*T511*T927+T359*T413*T349*T490*(1-params(11))*T337*exp(T337*y(23))));
  g1(23,23)=y(38)*(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T337*T337*exp(T337*y(23))))+y(37)*(-(T351*T372*T373*T327*(1-params(11))*params(3)*T337*T337*exp(T337*y(23))))+y(36)*(-(T386*T349*T373*T327*(1-params(11))*(1-params(3))*T337*T337*exp(T337*y(23))))+y(34)*(-(T626*T626*T927+T359*T353*(1-params(11))*T337*T337*exp(T337*y(23))));
  g1(23,34)=(-(T359*T626));
  g1(23,36)=(-(T386*T349*T373*T327*(1-params(11))*(1-params(3))*T337*exp(T337*y(23))));
  g1(23,37)=(-(T351*T372*T373*T327*(1-params(11))*params(3)*T337*exp(T337*y(23))));
  g1(23,38)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T337*exp(T337*y(23))));
  g1(23,55)=1+params(21)*(-params(15))+T249*(-params(16));
  g1(24,4)=T21*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T643));
  g1(24,6)=T665;
  g1(24,10)=y(52)*(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))))+y(48)*(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))))+y(39)*exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,18)=T473*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T643));
  g1(24,19)=exp(y(19))*T472*(-(exp(y(4))*params(6)*(-exp(y(31)-y(24)))*T643));
  g1(24,24)=T21*(-(exp(y(4))*params(6)*(exp(y(31)-y(24))*T643+(-exp(y(31)-y(24)))*(-exp(y(31)-y(24)))*T1449)))+y(52)*(-(exp(y(6))*exp((-y(24)))*exp(y(10))))+y(48)*(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))))+y(39)*exp(y(6))*params(6)*(-params(5))*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,31)=T21*(-(exp(y(4))*params(6)*((-exp(y(31)-y(24)))*T643+(-exp(y(31)-y(24)))*exp(y(31)-y(24))*T1449)));
  g1(24,39)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(24,48)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(24,52)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(24,54)=1;
  g1(24,64)=1-params(21);
  g1(25,57)=1;
  g1(26,58)=1;
  g1(27,59)=1;
  g1(28,60)=1;
  g1(29,61)=1;
  g1(30,62)=1;
  g1(31,4)=T21*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T643));
  g1(31,18)=T473*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T643));
  g1(31,19)=exp(y(19))*T472*(-(exp(y(4))*params(6)*exp(y(31)-y(24))*T643));
  g1(31,24)=T21*(-(exp(y(4))*params(6)*((-exp(y(31)-y(24)))*T643+exp(y(31)-y(24))*(-exp(y(31)-y(24)))*T1449)));
  g1(31,31)=y(56)*exp(y(31))+T21*(-(exp(y(4))*params(6)*(exp(y(31)-y(24))*T643+exp(y(31)-y(24))*exp(y(31)-y(24))*T1449)));
  g1(31,56)=exp(y(31));
  g1(32,63)=1;
  g1(33,64)=1;
  g1(34,15)=(-(params(11)*T339*T359));
  g1(34,16)=exp(y(16));
  g1(34,17)=(-(T359*T415));
  g1(34,18)=(-(T359*T511));
  g1(34,23)=(-(T359*T626));
  g1(35,1)=exp(y(1));
  g1(35,15)=(-(params(11)*T327*T331));
  g1(35,16)=(-(T395*params(11)*T377));
  g1(36,16)=(-(T386*T349*T373*T377*exp(T337*y(23))*(1-params(11))*(1-params(3))));
  g1(36,17)=(-(T386*T427));
  g1(36,18)=(-(T386*T349*T420*T423*T349*T490+T349*T373*T420*T505));
  g1(36,21)=exp(y(21));
  g1(36,23)=(-(T386*T349*T373*T327*(1-params(11))*(1-params(3))*T337*exp(T337*y(23))));
  g1(37,16)=(-(T351*T372*T373*exp(T337*y(23))*(1-params(11))*params(3)*T377));
  g1(37,17)=T442;
  g1(37,18)=(-(T372*T373*T433*T490+T351*T372*T433*T423*T349*T490));
  g1(37,20)=exp(y(20));
  g1(37,23)=(-(T351*T372*T373*T327*(1-params(11))*params(3)*T337*exp(T337*y(23))));
  g1(38,12)=exp(y(12));
  g1(38,17)=(-(exp(y(18)*(1-params(3)))*exp(T337*y(23))*params(3)*exp(y(17)*params(3))));
  g1(38,18)=T486;
  g1(38,23)=(-(exp(y(18)*(1-params(3)))*exp(y(17)*params(3))*T337*exp(T337*y(23))));
  g1(39,2)=exp(y(2));
  g1(39,3)=exp(y(3));
  g1(39,6)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)));
  g1(39,7)=exp(y(7))*params(6)*exp(y(11)*params(5));
  g1(39,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*(y(10)-y(24)));
  g1(39,11)=exp(y(7))*params(6)*params(5)*exp(y(11)*params(5));
  g1(39,16)=(-exp(y(16)));
  g1(39,17)=exp(y(17))-exp(y(17))*(1-params(10));
  g1(39,19)=exp(y(19));
  g1(39,24)=exp(y(6))*params(6)*exp(params(5)*(y(10)-y(24)))*(-params(5));
  g1(40,18)=exp(y(18));
  g1(40,21)=(-(T559*T564));
  g1(41,20)=(-(exp(y(22))*exp(y(20))));
  g1(41,22)=(-(exp(y(22))*(1+exp(y(20))-params(10))));
  g1(42,18)=(-((T21*T473*params(1)-T473*T21*params(1))/(T21*T21)));
  g1(42,19)=(-((T21*params(1)*exp(y(19))*T472-T21*params(1)*exp(y(19))*T472)/(T21*T21)));
  g1(42,22)=exp(y(22));
  g1(43,1)=(-(exp(y(22))*exp(y(1))*exp(y(11))));
  g1(43,11)=T273;
  g1(43,13)=1-exp(y(22))*(1-exp(y(11)));
  g1(43,22)=T590;
  g1(44,13)=(-params(7));
  g1(44,14)=1-exp(y(22))*(1-params(7));
  g1(44,22)=(-(y(14)*exp(y(22))*(1-params(7))));
  g1(45,3)=y(14)*T85*params(4)*(params(4)-1)*exp(y(3)*(params(4)-1));
  g1(45,14)=T85*params(4)*exp(y(3)*(params(4)-1));
  g1(46,1)=(-(exp(y(1))*exp(y(22))));
  g1(46,11)=exp(y(22))*params(6)*params(5)*(params(5)-1)*exp(y(11)*(params(5)-1));
  g1(46,13)=exp(y(22));
  g1(46,22)=T575;
  g1(47,7)=exp(y(7))-exp(y(7))*(1-exp(y(11)));
  g1(47,9)=(-(params(7)*exp(y(9))));
  g1(47,11)=(-(exp(y(7))*(-exp(y(11)))));
  g1(48,6)=exp(y(6))-exp(y(6))*(1-exp((-y(24)))*exp(y(10)));
  g1(48,8)=(-(exp(y(8))*params(7)));
  g1(48,10)=(-(exp(y(6))*(-(exp((-y(24)))*exp(y(10))))));
  g1(48,24)=(-(exp(y(6))*(-(exp(y(10))*(-exp((-y(24))))))));
  g1(49,3)=(-(T85*params(4)*exp(params(4)*y(3))));
  g1(49,9)=exp(y(9))-(1-params(7))*exp(y(9));
  g1(50,2)=(-(T66*params(4)*exp(y(2)*params(4))));
  g1(50,8)=exp(y(8))-exp(y(8))*(1-params(7));
  g1(51,5)=exp(y(5));
  g1(51,7)=(-(exp(y(11))*exp(y(7))));
  g1(51,11)=(-(exp(y(11))*exp(y(7))));
  g1(52,4)=exp(y(4));
  g1(52,6)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(52,10)=(-(exp(y(6))*exp((-y(24)))*exp(y(10))));
  g1(52,24)=(-(exp(y(6))*exp(y(10))*(-exp((-y(24))))));
  g1(53,4)=(-exp(y(4)));
  g1(53,5)=(-exp(y(5)));
  g1(53,15)=exp(y(15));
  g1(54,24)=1;
  g1(55,23)=1-(params(15)+params(16));
  g1(56,10)=(-exp(y(10)));
  g1(56,31)=exp(y(31));
  g1(57,25)=1;
  g1(58,26)=1;
  g1(59,27)=1;
  g1(60,28)=1;
  g1(61,29)=1;
  g1(62,30)=1;
  g1(63,32)=1;
  g1(64,33)=1;
  g1(65,64)=(-1);
  g1(65,65)=1;
  g1(66,63)=(-1);
  g1(66,66)=1;
  g1(67,55)=(-1);
  g1(67,67)=1;
  g1(68,23)=(-1);
  g1(68,68)=1;
  g1(69,11)=(-1);
  g1(69,69)=1;
  g1(70,10)=(-1);
  g1(70,70)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],70,4900);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],70,343000);
end
end
end
end
